package javabotsposh;

import cz.cuni.astar.AStar;
import cz.cuni.astar.AStarGoal;
import cz.cuni.astar.AStarMap;
import cz.cuni.astar.AStarResult;
import cz.cuni.pogamut.Client.AgentMemory;
import cz.cuni.pogamut.Client.GameMapAStarGoal;
import cz.cuni.pogamut.Client.GameMapAStarMap;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.AddAmmo;
import cz.cuni.pogamut.MessageObjects.AddHealth;
import cz.cuni.pogamut.MessageObjects.AddWeapon;
import cz.cuni.pogamut.MessageObjects.Ammo;
import cz.cuni.pogamut.MessageObjects.Extra;
import cz.cuni.pogamut.MessageObjects.Health;
import cz.cuni.pogamut.MessageObjects.ItemType;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.NeighNav;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.PlayerKilled;
import cz.cuni.pogamut.MessageObjects.Special;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.MessageObjects.Weapon;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import cz.cuni.sposhBot.java.JavaBehaviour;
import cz.cuni.sposhBot.java.SPoshBot;
import java.lang.Thread.State;
import java.util.Collections;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

/**Autor: Jiri Divis
 * Ramcovy zpusob fungovani bota:
 *      robot ma v podtate dva hlavni mody - utoceni a sbirani
 * 
 *      sbirani itemu:
 *          *sbira jen itemy, ktere chce
 *          *sbira itemy, ktere jsou v okoli
 *          *sbira nahodne vybrane vzdalene itemy
 *          *priorizuje podle toho ceho ma zrovna nedostatek
 *          *kdyz utoci tak aktivne nesbira itrmy
 *          *bohuzel nesbira shieldy
 * 
 *      utoceni:
 *          *pro vyber zbrani pouziva pogamuti metodu
 *          *zda se na nepritele rozhodne zautocit urcuji tyto faktory:
 *              *health level
 *              *weapons & ammmo level
 *              *zda na nej bylo zautoceno, nebo jen videl nejakeho bota
 *          *kdyz se nerozhodne zautocit tak pokracuje ve sbrani jako by se nic nedelo
 *          *pri utoceni se snazi uhejbat tak ze pri strelbe strafuje mezi navpointy
 *           ,ktere jsou blizko k nepritely a ze kterych na nej vidi 
 * 
 *      (asi jsem to uz opravil) bot vyjmecne spadne s tim, ze curEnemyLocation == null s cimz si nevim rady,
 *      protoze to nikde na null nenastavuju. ( mam jen podezreni ze je to zpusobuje odchytavani zprav )
 * 
 *      (asi jsem to uz opravil) podobne take vyjmecne a take na Null exception pada v sense_near_wanted_ammo
 *   
 */
public class MyBehaviour extends JavaBehaviour {

    Object msgMutex;
    Object msgMutex2;
    boolean isBotInitialized = false;
    AgentMemory memory = null;
    
    //private NavPoint nearWantedObject = null;
    //promene pouzite pro reseni kolizi a zadrhnuti
    private int numOfJumps = 0;
    private int timeFromLastJump = 6;
    int timeFromLastCollision = 0;

    //navpointy - drzi misto kam bot prave bezi pokud neni v attack modu
    private LinkedList<String> lastVisitedItems = null;
    private NavPoint nearRunToObject = null;
    private int nearRunToObjectTimeout = 0;
    private NavPoint curRunToObject = null;
    private int curRunToObjectTimeout = 0;
    private NavPoint farRunToObject = null;
    private int farRunToObjectTimeout = 0;
    private boolean nearRunToActive = false;
    //drzi zbrane a healths na mape
    private List<Weapon> knownWeapons = null;
    private List<Health> knownHealths = null;
    boolean knownWeaponsInit = true;

    //stavove promene utocne casti bota
    boolean isAttacked = false;
    NavPoint evasiveRunToWp = null;
    ArrayList<NavPoint> curRunToPath = null;
    private Player curEnemy = null;
    private Triple curEnemyLocation = null;
    private int timeFromLastCurEnemySee = 100000;

    //min a max effectiveDist zbarni ktere agent ma
    private int maxEffDist = 1000;
    private int minEffDist = 0;
    //????
    private LinkedList<NavPoint> previousLocations = null;

    private class KillListener implements RcvMsgListener {

        public KillListener() {
            bot.getBody().addTypedRcvMsgListener(this, MessageType.BOT_KILLED);
        }

        @Override
        public void receiveMessage(RcvMsgEvent e) {
            synchronized (msgMutex) {
                isBotInitialized = false;
            }
        }
        }

    private class PlayerDiedListener implements RcvMsgListener {

        public PlayerDiedListener() {
            bot.getBody().addTypedRcvMsgListener(this, MessageType.PLAYER_KILLED);
        }

        @Override
        public void receiveMessage(RcvMsgEvent e) {
            synchronized (msgMutex) {
                PlayerKilled kill = (PlayerKilled) e.getMessage();
                if (curEnemy.UnrealID.equals(kill.UnrealID)) {
                    timeFromLastCurEnemySee = 1000;
                }
            }

        }
    }

    private class WeaponListener implements RcvMsgListener {

        public WeaponListener() {
            bot.getBody().addTypedRcvMsgListener(this, MessageType.ADD_WEAPON);
        }

        @Override
        public void receiveMessage(RcvMsgEvent e) {
            AddWeapon weapon = (AddWeapon) e.getMessage();
            // check whether it is AIN message
            synchronized (msgMutex2) {
                if (weapon.ID == 0) {
                    // this means it is AIN message not INV message
                    
                    //pokud bylo sebran item pro ktery bot bezi
                    if (curRunToObject.UnrealID.compareTo(weapon.UnrealID) == 0) {
                        ResetRunTo();
                    }
                    lastVisitedItems.add(weapon.UnrealID);
                }
            }
        }
    }

    private class HealthListener implements RcvMsgListener {

        public HealthListener() {
            bot.getBody().addTypedRcvMsgListener(this, MessageType.ADD_HEALTH);
        }

        @Override
        public void receiveMessage(RcvMsgEvent e) {
            AddHealth health = (AddHealth) e.getMessage();
            // check whether it is AIN message
            synchronized (msgMutex2) {
                if (health.ID == 0) {
                    // this means it is AIN message not INV message
                    
                    //pokud bylo sebran item pro ktery bot bezi
                    if (curRunToObject.UnrealID.compareTo(health.UnrealID) == 0) {
                        ResetRunTo();
                    }
                    lastVisitedItems.add(health.UnrealID);
                }
            }
        }
    }

    private class AmmoListener implements RcvMsgListener {

        public AmmoListener() {
            bot.getBody().addTypedRcvMsgListener(this, MessageType.ADD_AMMO);
        }

        @Override
        public void receiveMessage(RcvMsgEvent e) {
            AddAmmo weapon = (AddAmmo) e.getMessage();
            // check whether it is AIN message
            synchronized (msgMutex2) {
                if (weapon.ID == 0) {
                    // this means it is AIN message not INV message
                    
                    //pokud bylo sebran item pro ktery bot bezi
                    if (curRunToObject.UnrealID.compareTo(weapon.UnrealID) == 0) {
                        ResetRunTo();
                    }
                    lastVisitedItems.add(weapon.UnrealID);
                }
            }
        }
    }

    public MyBehaviour(String name, Logger log, SPoshBot bot) {
        super(name, log, bot);
        memory = bot.getMemory();
        previousLocations = new LinkedList<NavPoint>();
        lastVisitedItems = new LinkedList<String>();
        knownWeapons = new LinkedList<Weapon>();
        msgMutex = new Object();
        msgMutex2 = new Object();
        isBotInitialized = false;
    }
    //***************Actions*******************************************
    //***********actions-pohyb a sber veci*************************************
    public boolean action_initialzie() {
        BotReInit();
        return true;
    }

    public boolean action_cancel_collect() {
        this.log.log(Level.FINER, "action: canceling collect!!!");
        ResetRunTo();
        return true;
    }

    public boolean action_unstuck() {
        this.log.log(Level.FINER, "action: unstuck");


        if (numOfJumps < 2 && timeFromLastJump > 6) {
            //pokud zavolani unstuck bylo zpusobeno kolizi a neuplynulo dost casu
            //od posledniho jumpu ...
            if (timeFromLastCollision < 2 && timeFromLastJump < 18 && numOfJumps == 0) {
                return true;
            }
            timeFromLastJump = 0;
            bot.getBody().jump();
            numOfJumps++;
            bot.getBody().stop();
        }

        if (numOfJumps == 2 && timeFromLastJump >= 1) {
            timeFromLastJump = 0;
            bot.getBody().jump();
            numOfJumps++;
        }
        return true;
    }

    public boolean action_TurnAround() {
        this.log.log(Level.FINER, "action: turn around");
        bot.getBody().turnHorizontal(45);

        return true;
    }

    public boolean action_pick_random_item() {
        this.log.log(Level.FINER, "action: random run");
        if (farRunToObject != null) {
            return true;
        }

        List<NavPoint> items = memory.getKnownNavPoints();


        for (NavPoint n : items) {
            synchronized (msgMutex2) {
                if (n.item == null) {
                    continue;
                }
                synchronized (msgMutex2) {
                    if (lastVisitedItems.contains(n.UnrealID)) {
                        continue;
                    }
                }
            }

            this.log.warning("adding: " + n.UnrealID);
            farRunToObject = n;
            farRunToObjectTimeout = 1000;
            curRunToObject = n;
            curRunToObjectTimeout = 1000;
            nearRunToActive = false;

            return true;
        }
        return false;
    }


    //***************actions-utok*******
    //vybere zbran a zacne strilet
    public boolean action_shoot() {
        this.log.log(Level.FINER, "action: shoot");
        bot.getBody().changeWeapon(memory.getBetterWeapon(curEnemyLocation, memory.getAgentLocation()));
        if (!memory.getCurrentWeapon().melee) {
            AddWeapon w = memory.getMeleeWeapon();
            if (w != null) {
                bot.getBody().changeWeapon(w);
            }

        }
        bot.getBody().shoot(curEnemy);
        return true;
    }

    public boolean action_stop_shoot() {
        this.log.log(Level.FINER, "action: stop shoot");
        bot.getBody().stopShoot();
        return true;
    }

    public boolean action_run_to_enemy() {
        this.log.log(Level.FINER, "action: run to enemy");
        if(curEnemyLocation==null){
            return false;
        }
        bot.getMap().safeRunToLocation(curEnemyLocation);
        return true;
    }

    //vybere navpoint, ktery je vzdalenostne od enemy v mezich effectiveDist zbrani, ktere agent ma
    public boolean action_pick_evasive_run_to_wp() {
        this.log.log(Level.FINER, "action: pick evasive run wp");
        if (evasiveRunToWp != null) {
            return true;
        }

        //spocita min a max effective dist. zbrani ktere agent ma
        List<AddWeapon> weapons = memory.getCopyOfAllWeapons();
        minEffDist = 10000;
        maxEffDist = 0;

        for (AddWeapon w : weapons) {
            if (w.effectiveDist > maxEffDist) {
                maxEffDist = w.effectiveDist;
            }
            if (w.effectiveDist < minEffDist) {
                minEffDist = w.effectiveDist;
            }
        }



        NavPoint nearestNP = bot.getMap().nearestNavPoint(memory.getAgentLocation());
        List<NeighNav> neighbours = nearestNP.neighbours;
        Collections.shuffle(neighbours);

        for (NeighNav nn : neighbours) {
            if(curEnemyLocation==null){
                return false;
            }
            double nnDist = Triple.distanceInSpace(curEnemyLocation, nn.neighbour.location);
            if (nnDist < maxEffDist && nnDist > minEffDist) {
                evasiveRunToWp = nn.neighbour;
                return true;
            }
        }
        bot.getBody().turnToLocation(curEnemyLocation);
        return false;
    }

    //strafuje k vybranemu waypointu z predchozi funkce
    public boolean action_evasive_run_to() {
        this.log.log(Level.FINER, "action: eveasive run to");
        
        this.log.log(Level.WARNING, "evasion: " + evasiveRunToWp.UnrealID);
        bot.getBody().strafeToLocation(evasiveRunToWp.location, curEnemyLocation);
        //bot.getBody().jump();
        if (Triple.distanceInSpace(evasiveRunToWp.location, memory.getAgentLocation()) < 50) {
            evasiveRunToWp = null;
            this.log.log(Level.WARNING, "evasion: At location");
            return true;
        }
        return true;
    }

    //***************Senses********************************************
    //**************senses-utok***************************************************
    public boolean sense_is_engaging_enemy() {
        this.log.log(Level.FINER, "sense: is engaging enemy");
        return curEnemy != null;
    }

    public boolean sense_is_shooting() {
        this.log.log(Level.FINER, "sense: is shoothing");
        return memory.isShooting();
    }

    public boolean sense_see_enemy() {
        this.log.log(Level.FINER, "sense: see_enemy");
        //najit rozdil mezi enemy a player
        synchronized (msgMutex) {
            Player tmpEnemy = memory.getSeeEnemy();
            if (curEnemy == null) {
                curEnemy = tmpEnemy;
                bot.getBody().turnToTarget(curEnemy);
            }


            if (tmpEnemy == null) {
                //pokud nevidi nepritele
                timeFromLastCurEnemySee++;
                evasiveRunToWp = null;
            } else {
                curEnemyLocation = new Triple(tmpEnemy.location.x, tmpEnemy.location.y, tmpEnemy.location.z);
                timeFromLastCurEnemySee = 0;
            }
            if (curEnemy != null) {
            //bot.getBody().turnToTarget(curEnemy);
            }
            return tmpEnemy != null;
        }
    }

    //urci zda agent bude nadale pronasledovat nepritele
    public boolean sense_enemy_lost() {
        this.log.log(Level.FINER, "sense: enemy lost");
        if (timeFromLastCurEnemySee > 50) {
            curEnemy = null;
            evasiveRunToWp = null;
            return true;
        } else {
            return false;
        }
    }

    public boolean sense_is_attacked() {
        this.log.log(Level.FINER, "sense: sense is attacked");
        if (memory.isBeingDamaged() || memory.isProjectileComming()) {
            isAttacked = true;
            timeFromLastCurEnemySee = 0;
            return true;
        } else {
            return false;
        }
    }

    //********************************************
    public boolean sense_is_initialized() {
        log.log(Level.WARNING, "--------end of iteration--------");
        return !isBotInitialized;
    }

    //*************senses-sber veci******************
    
    //pokud vidi nejaky health ve vzdalenosti 3 navpointu
    public boolean sense_near_wanted_health() {
        this.log.log(Level.FINER, "sense: near wanted health");
        
        if (nearRunToObject == null) {
            nearRunToActive = false;
        }
        if (nearRunToActive) {
            this.log.info("near_wanted_health sense - false");
            return true;
        }


        List<Health> healths = memory.seenHealths(3000);
        Collections.shuffle(healths);
        for (Health health : healths) {
            synchronized (msgMutex2) {
                if (WantThisHealth(health) == 0 || lastVisitedItems.contains(health.navPoint.UnrealID)) {
                    continue;
                }
            }
            curRunToPath = getPathAStar(health.navPoint, 3);
            if (curRunToPath != null) {
                nearRunToObject = health.navPoint;
                nearRunToObjectTimeout = 40;
                curRunToObject = health.navPoint;
                curRunToObjectTimeout = 40;
                nearRunToActive = true;
                bot.getMap().initializeRunAlongPath(curRunToPath);
                return true;
            }
        }
        return false;
    }

    //pokud vidi nejaky ammo ve vzdalenosti 3 navpointu
    public boolean sense_near_wanted_ammo() {
        this.log.log(Level.FINER, "sense: near wanted ammo");
        
        if (nearRunToObject == null) {
            nearRunToActive = false;
        }
        if (nearRunToActive) {
            this.log.info("near_wanted_ammo sense - false");
            return true;
        }

        List<Weapon> weapons = memory.seenWeapons(3000);
        Collections.shuffle(weapons);
        this.log.warning(String.format("%d", weapons.size()));
        for (Weapon weapon : weapons) {

            synchronized (msgMutex2) {
                if (weapon == null || weapon.navPoint==null || lastVisitedItems==null) {
                    this.log.log(Level.SEVERE, "weapon is null!!!!!");
                    return false;
                }
                if (WantThisWeapon(weapon) == 0 || lastVisitedItems.contains(weapon.navPoint.UnrealID)) {//
                    continue;
                }



                this.log.warning("considering weapon: " + weapon.weaponType);//
                curRunToPath = getPathAStar(weapon.navPoint, 3);//
                if (curRunToPath != null) {
                    this.log.warning("adding weapon: " + weapon.weaponType);
                    nearRunToObject = weapon.navPoint;//
                    nearRunToObjectTimeout = 40;
                    curRunToObject = weapon.navPoint;//
                    curRunToObjectTimeout = 40;
                    nearRunToActive = true;
                    bot.getMap().initializeRunAlongPath(curRunToPath);
                    return true;
                }
            }
        }

        List<Ammo> ammos = memory.seenAmmos(3000);
        Collections.shuffle(ammos);
        this.log.warning(String.format("%d", ammos.size()));
        for (Ammo ammo : ammos) {
            synchronized (msgMutex2) {
                if (WantThisAmmo(ammo) == 0 || lastVisitedItems.contains(ammo.navPoint.UnrealID)) {
                    continue;
                }
            }
            this.log.warning("considering ammo: " + ammo.typeOfWeapon + ammo.type);
            curRunToPath = getPathAStar(ammo.navPoint, 3);
            if (curRunToPath != null) {
                this.log.warning("adding ammo: " + ammo.typeOfWeapon);
                nearRunToObject = ammo.navPoint;
                nearRunToObjectTimeout = 40;
                curRunToObject = ammo.navPoint;
                curRunToObjectTimeout = 40;
                nearRunToActive = true;
                bot.getMap().initializeRunAlongPath(curRunToPath);
                return true;
            }
        }
        return false;
    }

    //pokud existuje v mape nejaka zbran kterou agen chce
    public boolean sense_far_wanted_ammo() {
        this.log.log(Level.FINER, "sense: far wanted ammo");
        if (knownWeaponsInit) {
            knownWeapons.clear();
            for (Weapon weapon : memory.getKnownWeapons()) {
                knownWeapons.add(weapon);
            }
            knownWeaponsInit = false;
        }
        if (farRunToObject != null) {
            return true;
        }


        this.log.info("far_wanted_ammo sense");
        List<Weapon> weapons = knownWeapons;


        //last visited dump
        for (String str : lastVisitedItems) {
            this.log.warning("last items: " + str);
        }

        this.log.warning("x total weapons: " + String.format("%d", knownWeapons.size()));
        List<AddWeapon> wps = memory.getCopyOfAllWeapons();
        this.log.warning("my total weapons: " + String.format("%d", wps.size()));

        for (Weapon w : weapons) {
            synchronized (msgMutex2) {
                if (WantThisWeapon(w) == 0 || lastVisitedItems.contains(w.navPoint.UnrealID)) {
                    continue;
                }
            }
            this.log.warning("adding: " + w.weaponType);
            farRunToObject = w.navPoint;
            farRunToObjectTimeout = 1000;
            curRunToObject = w.navPoint;
            curRunToObjectTimeout = 1000;
            nearRunToActive = false;
            return true;
        }
        return false;
    }

    //pokud existuje v mape nejaky health ktery agent chce
    public boolean sense_far_wanted_health() {
        if (farRunToObject != null) {
            return true;
        }
        this.log.log(Level.FINER, "sense: near wanted health");

        synchronized (msgMutex2) {
            if (knownHealths == null) {
                this.log.log(Level.SEVERE, "health null");
            } else {
                this.log.log(Level.SEVERE, "health ok");
            }
            this.log.info("size hea.: " + String.format("%d", knownHealths.size()));
            for (Health h : knownHealths) {
                if (WantThisHealth(h) == 0 || lastVisitedItems.contains(h.navPoint.UnrealID)) {
                    continue;
                }
                this.log.info("considering hea.: " + h.UnrealID);
                farRunToObject = h.navPoint;
                farRunToObjectTimeout = 1000;
                curRunToObject = h.navPoint;
                curRunToObjectTimeout = 1000;
                nearRunToActive = false;
                return true;
            }
            return false;
        }
    }

    public boolean sense_is_stuck() {
        this.log.log(Level.FINER, "sense: is stuck");

        //stuk je bud pokud se jeho nedavna trasa da uzavrit do maleho kruhu a nebo pokud isColliding
        if (isRunningInCircle() || memory.isColliding()) {
            timeFromLastCollision = 0;
        } else {
            timeFromLastCollision++;
        }

        timeFromLastJump++;
        if (timeFromLastCollision < 2) {
            return true;
        } else {
            this.log.info("Reseting jups!!!!!!!!!!!!!");
            numOfJumps = 0;
            return false;
        }
    }

    public boolean sense_cant_unstuck() {
        this.log.log(Level.FINER, "sense: cant unstuck");
        if (numOfJumps > 2) {
            return true;
        } else {
            return false;
        }
    }

    public int sense_health_level() {
        this.log.log(Level.FINER, "sense: health level value");
        return memory.getAgentHealth();
    }

    public int sense_ammo_level() {
        this.log.log(Level.FINER, "sense: ammo level value");
        List<AddWeapon> weapons = memory.getCopyOfAllWeapons();

        int wAll = 0;
        int wRanged = 0;
        int wMelee = 0;
        for (AddWeapon weapon : weapons) {
            if (weapon.currentAmmo > weapon.maxAmmo * 0.24) {
                wAll++;
                if (weapon.melee) {
                    wMelee++;
                } else {
                    wRanged++;
                }
            }
        }

        return wMelee * 15 + wRanged * 8;
    }

    //pokud dobehne na misto kam bezel - curRunToObject
    public boolean sense_at_location() {
        this.log.log(Level.FINER, "sense: at location");

        if (curRunToObject == null) {
            this.log.warning("shouldn't be here - at_location - runTo is null");
            return true;
        }

        this.log.warning("running to: " + curRunToObject.UnrealID);

        boolean runToResult;

        if (!nearRunToActive) {
            runToResult = bot.getMap().safeRunToLocation(curRunToObject.location);
        } else {
            runToResult = bot.getMap().runAlongPath();
        }


        if (Triple.distanceInSpace(curRunToObject.location, memory.getAgentLocation()) < 80 || !runToResult) {
            ResetRunTo();
            return true;
        }

        return false;
    }

    public boolean sense_run_timeout() {
        this.log.log(Level.FINER, "sense: run timeout");
        curRunToObjectTimeout--;
        nearRunToObjectTimeout--;
        farRunToObjectTimeout--;

        if (curRunToObjectTimeout <= 0) {
            return true;
        }
        return false;
    }

    //*********************fail, succeed & do nothing************
    //***********************************************************
    public boolean sense_fail_1() {
        this.log.info("Sense fail called.");
        return false;
    }

    public boolean sense_fail_2() {
        this.log.info("Sense fail_2() called.");
        return false;
    }

    public boolean sense_fail_3() {
        this.log.info("Sense fail_3() called.");
        return false;
    }

    public boolean sense_succeed_1() {
        this.log.info("Sense succeed_1() called.");
        return true;
    }

    public boolean sense_succeed_2() {
        this.log.info("Sense succeed_2() called.");
        return true;
    }

    public boolean sense_succeed_3() {
        this.log.info("Sense succeed_3() called.");
        return true;
    }

    public boolean action_doNothing_1() {
        this.log.info("Action doNothing_1() called.");
        try {
            Thread.sleep(100);
        } catch (InterruptedException e) {
        }
        return true;
    }

    public boolean action_doNothing_2() {
        this.log.info("Action doNothing_2() called.");
        try {
            Thread.sleep(100);
        } catch (InterruptedException e) {
        }
        return true;
    }

    //***********************************************************
    //**************pomocny funkce pro atcions & senses**********
    public ArrayList<NavPoint> getPathAStar(NavPoint toWhat, int maxNumOfIterations) {
        if (toWhat == null) {
            return null;
        }
        // initialize the AStarGoal, that will tell the AStar when to stop (that's why
        // we're passing the 'toWhat' as an argument
        AStarGoal goal = new GameMapAStarGoal(toWhat);
        // wrapper for the navpoints the GB sends us
        AStarMap map = new GameMapAStarMap();

        // now we have to construct the begin point for the AStar
        // as the AStar is working over NavPoint, it has to be NavPoint
        NavPoint start = new NavPoint();
        // make the start.location as bot's location
        start.location = bot.getMemory().getAgentLocation();
        // and constructs it's neighbours (NeighNav is better viewed as EDGE in the navpoint graph)
        start.neighbours = new ArrayList<NeighNav>();
        // get all the navpoints the bot can see
        ArrayList<NavPoint> nvs = bot.getMemory().seeAllNavPoints();
        if (nvs.size() == 0) {
            nvs = memory.getKnownNavPoints();
        }
        NeighNav nn;
        for (NavPoint navPoint : nvs) {
            // and if the navpoint is reachable, add it as a neighbour to our start
            if (navPoint.reachable) {
                nn = new NeighNav();
                nn.neighbour = navPoint;
                start.neighbours.add(nn);
            }
        }
        // fire tha AStar
        AStarResult result = AStar.aStar(goal, map, start, maxNumOfIterations);
        // and if it succeeds
        if (!result.success) {
            return null;
        }
        // return the list of navpoints
        return bot.getMap().getNavPointsAStar(result);
    }

    protected boolean isRunningInCircle() {
        if (previousLocations.size() > 36) {
            previousLocations.removeFirst();
        }


        NavPoint tmpNavPoint = new NavPoint();
        tmpNavPoint.location = memory.getAgentLocation();
        previousLocations.addLast(tmpNavPoint);

        NavPoint center = previousLocations.peekFirst();

        for (NavPoint navPoint : previousLocations) {
            if (Triple.distanceInSpace(center.location, navPoint.location) > 300) {
                return false;
            }
        }

        /*NavPoint tmpNavPoint = new NavPoint();
        tmpNavPoint.location = memory.getAgentLocation();
        previousLocations.add(tmpNavPoint);
        this.log.info(String.format("%f",pathLength(previousLocations)));
        return pathLength(previousLocations);*/
        return true;
    }

    public double pathLength(List<NavPoint> path) {
        double length = 0;
        Triple lastLocation = memory.getAgentLocation();
        for (NavPoint navPoint : path) {
            length += Triple.distanceInPlane(lastLocation, navPoint.location);
            lastLocation = navPoint.location;
        }
        return length;
    }

    protected NavPoint nearestNavpoint() {
        // get all navpoints we know of
        List<NavPoint> navPoints = memory.getKnownNavPoints();
        // here we will keep the distance from currently known closest navpoint
        double nearestNavPointDistance = Double.MAX_VALUE;
        // this will store the nearest navpoint, it will be computer in for-cycle...
        NavPoint nearestNavPoint = null;
        // query the agent location
        Triple myLocation = memory.getAgentLocation();
        // and go through all the navpoints we know of...
        for (NavPoint navPoint : navPoints) {
            // always count the distance between the bot and navPoint
            double navPointDistance = Triple.distanceInPlane(navPoint.location, myLocation);
            // if it is closer then currently found navpoint
            if (navPointDistance < nearestNavPointDistance) {
                // remember it
                nearestNavPoint = navPoint;
                nearestNavPointDistance = navPointDistance;
            }
        }
        // return the navpoint we have found
        return nearestNavPoint;
    }

    //pri startu a po kazdem zabiti agenta
    void BotReInit() {
        timeFromLastCollision = 10;
        isAttacked = false;
        synchronized (msgMutex) {
            isBotInitialized = true;
        }
        timeFromLastCurEnemySee = 100000;
        //curEnemyLocation = null;
        numOfJumps = 0;
        timeFromLastJump = 1000;
        previousLocations.clear();
        synchronized (msgMutex2) {
            lastVisitedItems.clear();
        }
        nearRunToObject = null;
        nearRunToObjectTimeout = 0;
        curRunToObject = null;
        curRunToObjectTimeout = 0;
        farRunToObject = null;
        farRunToObjectTimeout = 0;
        nearRunToActive = false;
        if (!knownWeaponsInit) {
            knownWeapons = memory.getKnownWeapons();
            Collections.shuffle(knownWeapons);
        }
        knownWeaponsInit = true;
        evasiveRunToWp = null;
        maxEffDist = 1000;
        minEffDist = 0;
        isAttacked = false;

        //health init - velky dopredu

        List<Health> allHealths = memory.getKnownHealths();
        List<Health> smallHealths = new LinkedList<Health>();
        knownHealths = new LinkedList<Health>();
        for (Health h : allHealths) {
            if (h.strength > 10) {
                knownHealths.add(h);
            } else {
                smallHealths.add(h);
            }
        }
        Collections.shuffle(knownHealths);
        Collections.shuffle(smallHealths);
        knownHealths.addAll(smallHealths);
    }

    private void ResetRunTo() {
        synchronized (msgMutex2) {
            this.log.info("Reseting jups!!!!!!!!!!!!!;");
            numOfJumps = 0;
            timeFromLastCollision = 10;

            this.log.warning("Reseting path!!!!!!;");

            this.log.warning("visite size: " + String.format("%d", lastVisitedItems.size()));


            if (!lastVisitedItems.contains(curRunToObject.UnrealID)) {
                this.log.warning("adding: " + curRunToObject.UnrealID);
                lastVisitedItems.addLast(curRunToObject.UnrealID);
            }
            if (lastVisitedItems.size() >= 12) {
                this.log.warning("removing: " + lastVisitedItems.peekFirst());
                lastVisitedItems.removeFirst();

            }

            //cancel runto near object
            nearRunToObject = null;
            nearRunToObjectTimeout = 0;

            //cancel run to far object or resume runto far object if near was active
            if (nearRunToActive && farRunToObjectTimeout > 0) {
                curRunToObject = farRunToObject;
                curRunToObjectTimeout = farRunToObjectTimeout;
                nearRunToActive = false;
            } else {
                farRunToObject = null;
                farRunToObjectTimeout = 0;
                curRunToObject = null;
                curRunToObjectTimeout = 0;
                nearRunToActive = false;
            }
        }
    }

    private int WantThisHealth(Health h) {
        if (memory.getAgentHealth() >= 195) {
            return 0;
        }

        if (h.typeOfHealth == ItemType.MINI_HEALTH_PACK) {
            return 1;
        }

        if (memory.getAgentHealth() >= 100) {
            if (h.typeOfHealth != ItemType.MINI_HEALTH_PACK) {
                return 0;
            }
        }

        if (memory.getAgentHealth() < 90) {
            return 2;
        }

        return 0;
    }

    private int WantThisWeapon(Weapon w) {
        for (AddWeapon cw : memory.getCopyOfAllWeapons()) {
            if (cw.weaponType == w.weaponType) {
                if (cw.currentAmmo < cw.maxAmmo * 0.24) {
                    return 1;
                } else {
                    return 0;
                }
            }
        }
        return 1;
    }

    private int WantThisAmmo(Ammo a) {
        if (memory.isAmmoSuitable(a)) {
            for (AddWeapon cw : memory.getCopyOfAllWeapons()) {
                if (cw.weaponType == a.typeOfWeapon) {
                    if (cw.currentAmmo < cw.maxAmmo * 0.95) {
                        return 1;
                    } else {
                        return 0;
                    }
                }
            }
            return 1;
        } else {
            return 0;
        }
    }
}
